﻿<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>


<%@ Import Namespace="Soneta.Place.Forms" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Place" %>
<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Import Namespace="System.Linq" %>
<%@ Import Namespace="System.Collections.Generic" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Wykaz przelewów na ROR</title>
    <script runat="server">
		
	public class PrnParams: ActualContext {
		public PrnParams(Context context): base(context) {
		}
		[Caption("Data przelewu")]
		public override Date Aktualny {
			get { return base.Aktualny; }
			set { base.Aktualny = value; }
		}
		bool adres;
		[Caption("Drukuj adres pracownika")]
		public bool Adres {
			get { return adres; }
			set { adres = value; }
		}
	}
	PrnParams pars;		
	[Context]
	public PrnParams Params { 
		get { return pars; } 
		set { pars = value; } 
	} 
			
	class Total :IComparer
     {
		ArrayList przelewy = new ArrayList();
        Boolean sorted=true;
		Currency razem ;
		private readonly EwidencjaSP ewidencja;
		private readonly String symbol;

		public Total(EwidencjaSP ewidencja, String symbolWaluty) 
		{
			this.ewidencja = ewidencja;
			this.symbol = symbolWaluty;
			this.razem = new Currency (0m, symbolWaluty );
		}

		public void Add(PrzelewBase pzl)
       {
			przelewy.Add(new PrzelewProxy(pzl));
            sorted=false;
			razem += pzl.Kwota;
		}
		public EwidencjaSP Ewidencja {
			get { return ewidencja; }
		}
		public String SymbolWaluty {
			get { return symbol; }
		}
		public IEnumerable Przelewy 
        {
			get { RequestSort(); return przelewy; }
		}
		public Currency Razem {
			get { return razem; }
		}


            private void RequestSort()
            {
                if(!sorted)
                {
                    przelewy.Sort(this);
                    sorted=true;
                }
            }

            public int Compare(Object o1, Object o2)
            {
                PrzelewProxy p1 = (PrzelewProxy) o1;
                PrzelewProxy p2 = (PrzelewProxy) o2;

                return 10 * Math.Sign(CompareBankName(p1,p2)) + Math.Sign(CompareName(p1,p2));
            }

            private int CompareBankName(PrzelewProxy p1, PrzelewProxy p2)
            { return String.Compare(p1.NazwaCore??String.Empty, p2.NazwaCore??String.Empty); }

            private int CompareName(PrzelewProxy p1, PrzelewProxy p2)
            { return String.Compare(p1.Przelew.NazwaOdbiorcy1, p2.Przelew.NazwaOdbiorcy1); }
	    }


            class PrzelewProxy
            {
                public PrzelewBase Przelew {get;private set;}

                public PrzelewProxy(PrzelewBase p)
                {this.Przelew = p;}

                public String NazwaBanku
                { get { return NazwaCore ?? "(bez nazwy banku)"; }}

                public String NazwaCore
                {
                    get
                    {
                        if(Przelew.Rachunek != null && Przelew.Rachunek.Rachunek != null && Przelew.Rachunek.Rachunek.Bank != null)
                            return Przelew.Rachunek.Rachunek.Bank.Nazwa;
                        return null;
                    }
                }
            }


	
    void OnContextLoad(Object sender, EventArgs args) {	
		if (!pars.Adres) {
			adres.Visible = false;
			lp.RowSpan = 1;
			konto.RowSpan = 1;
			kwota.RowSpan = 1;
			Grid1.RowsInRow = 1;
		}
    
		List<Total> totals = new List<Total>();
		Row[] rows = (Row[])dc[typeof(Row[])];


		foreach (PrzelewBase pzl in rows) 
			if (pzl.Podmiot is Pracownik)
			{
				Total t = totals.FirstOrDefault(tx => tx.Ewidencja == pzl.EwidencjaSP && tx.SymbolWaluty == pzl.Kwota.Symbol);
					if (t==null)
					 {
						t = new Total(pzl.EwidencjaSP,  pzl.Kwota.Symbol);
						totals.Add(t);
					}
					t.Add(pzl);
			}

	    totals.Sort(CompareTotals);
		
		DataRepeater1.DataSource = totals;
		ReportHeader2["DATA"] = pars.Aktualny.ToString();
		Grid2.DataSource = totals;
	}


	    private static int CompareTotals(Total t1, Total t2)
	    {
			int comp= t1.Ewidencja.CompareTo(t2.Ewidencja);
		    if (comp != 0) return comp;
		    return t1.SymbolWaluty.CompareTo(t2.SymbolWaluty);
	    }

	
    void OnBeforeRow(Object sender, EventArgs args) {
		Total t = (Total)DataRepeater1.CurrentRow;
		ReportHeader1.Title = string.Format("WYKAZ PRZELEWÓW NA ROR|Data: {0}|Z rachunku: {1}|Numer:{2}",
			pars.Aktualny,
			t.Ewidencja,
			t.Ewidencja.Rachunek.Numer
			);
	}
	
	</script>
</head>
<body>
    <form id="WykazPrzelewówNaROR" method="post" runat="server">
        <ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad"></ea:datacontext>
        <ea:datarepeater id="DataRepeater1" runat="server" height="140px" width="100%" onbeforerow="OnBeforeRow">
				<ea:PageBreak id="PageBreak1" runat="server" BreakFirstTimes="False"></ea:PageBreak>
				<cc1:ReportHeader id="ReportHeader1" title="WYKAZ PRZELEWÓW NA ROR|Z dnia: %DATA%|Z rachunku: %RACHUNEK%|Numer:%NUMER%" runat="server"></cc1:ReportHeader>
				<ea:Grid id="Grid1" runat="server" GroupLine="{0}" GroupData0="NazwaBanku" DataMember="Przelewy" RowsInRow="2" >
					<Columns>
						<ea:GridColumn Width="4" Align="Center" DataMember="#" Caption="Lp." ID="lp" RowSpan="2"></ea:GridColumn>
						<ea:GridColumn Width="0" DataMember="Przelew.NazwaOdbiorcy1" Caption="Pracownik" ID="pracownik" NoWrap="True"></ea:GridColumn>
						<ea:GridColumn DataMember="Przelew.NazwaOdbiorcy2" Caption="Adres" ID="adres"></ea:GridColumn>
						<ea:GridColumn Width="40" DataMember="Przelew.RachunekOdbiorcy" Total="Info" Caption="Nr konta" ID="konto" RowSpan="2"></ea:GridColumn>
						<ea:GridColumn Width="16" Align="Right" DataMember="Przelew.Kwota" Total="Sum" Caption="Kwota" ID="kwota" RowSpan="2"></ea:GridColumn>
					</Columns>
				</ea:Grid>
				<cc1:ReportFooter id="ReportFooter1" runat="server" TheEnd="False">
					<Subtitles>
						<cc1:FooterSubtitle Caption="Sporządził" SubtitleType="Podpis" Width="33"></cc1:FooterSubtitle>
						<cc1:FooterSubtitle Caption="Sprawdził" SubtitleType="Podpis" Width="33"></cc1:FooterSubtitle>
						<cc1:FooterSubtitle Caption="Zatwierdził" SubtitleType="Podpis" Width="33"></cc1:FooterSubtitle>
					</Subtitles>
				</cc1:ReportFooter>
			</ea:datarepeater>
        <ea:pagebreak id="PageBreak2" runat="server"></ea:pagebreak>
        <cc1:reportheader id="ReportHeader2" title="WYKAZ PRZELEWÓW NA ROR - ZESTAWIENIE|Z dnia: %DATA%" runat="server"></cc1:reportheader>
        <ea:grid id="Grid2" runat="server" datamember="Przelewy">
				<Columns>
					<ea:GridColumn Width="4" Align="Center" DataMember="#" Caption="Lp."></ea:GridColumn>
					<ea:GridColumn Width="0" DataMember="Ewidencja.Nazwa" Caption="Rachunek" NoWrap="True"></ea:GridColumn>
					<ea:GridColumn Width="40" DataMember="Ewidencja.Rachunek.Numer" Total="Info" Caption="Numer"></ea:GridColumn>
					<ea:GridColumn Width="17" Align="Right" DataMember="Razem" Total="Sum" Caption="Kwota" ></ea:GridColumn>
				</Columns>
			</ea:grid>
        <cc1:reportfooter id="ReportFooter2" runat="server" theend="False">
				<Subtitles>
					<cc1:FooterSubtitle Caption="Sporządził" SubtitleType="Podpis" Width="33"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="Sprawdził" SubtitleType="Podpis" Width="33"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="Zatwierdził" SubtitleType="Podpis" Width="33"></cc1:FooterSubtitle>
				</Subtitles>
			</cc1:reportfooter>
    </form>
</body>
</html>

